
/*
 * Example 2 during tutorials on April 5, 2016.
 * Provided by Prof. Manzara.
 */
public class PingPong2 extends Object implements Runnable{
	private String word;
	private int delay;
	
	/**
	 * Creates a PingPong object which implements the Runnable interface.
	 * @param whatToSay The text to print out when the thread starts.
	 * @param delayTime The length of time to pause before printing the text again.
	 */
	public PingPong2(String whatToSay, int delayTime){
		super(); // We extended Object, so we should call the super constructor.
		word = whatToSay;
		delay = delayTime;
	}
	
	/**
	 * In Example 1, you saw that all Thread objects have a run() method. If you do not extend thread, and instead
	 * implement Runnable, you are expecting to pass this object into a Thread. As such, you still need to have a
	 * run() method, so that the program knows what to do when you start the Thread.
	 */
	public void run(){
		try{
			// loop infinitely
			for(;;){
				System.out.print(word + " ");
				//this.sleep(delay); // Ex 1. Wait for <delay>(ms) eg. 1000ms before continuing and printing the word again.
				Thread.sleep(delay); // Ex 2. Because PingPong2 is not extending Thread, it does not have a sleep() method.
									 // Instead, we have to call Thread.sleep(delay);
			}
		}catch(InterruptedException e){
			// When you use the sleep() method, you tell your thread to wait and do nothing for a while. During this
			// time, if the thread is aborted or forced to continue, it will throw an InterruptedException. This
			// exception must be handled or your program will not compile.
			return;
		}
	}
	
	public static void main(String[] args){
		//PingPong t1, t2;					// Ex 1. We created PingPong Thread objects before, but PingPong2 does not extend Thread.
		Thread t1, t2;						// Ex 2. We want to create two threads, not two PingPong2 objects.
		//t1 = new PingPong("ping", 40);				// Ex 1. Create the thread directly.
		//t2 = new PingPong("PONG", 100);				// Ex 1. Create the thread directly.
		t1 = new Thread(new PingPong2("ping", 40));		// Ex 2. Create an object which implements Runnable, then pass into a Thread.
		t2 = new Thread(new PingPong2("PONG", 100));	// Ex 2. Create an object which implements Runnable, then pass into a Thread.
		t1.start();							// start the first thread
		t2.start();							// start the second thread
		
		// You will see both threads printing to the output independent of each other. If you did not use multithreading,
		// it would print "ping" and "PONG" in an alternating fashion.
	}
}
